<?php
/*
Template Name: Ex Page Template
*/
get_header(); 
?>

<section class="main" id="main">
    <div class="main__image_bg"> 
        <img src="<?php echo get_field('ex_banner_bg_b2'); ?>" alt="">
    </div>
    <div class="main__image_players"> 
        <?php $players_image = get_field('ex_banner_players_b2'); ?>
        <img src="<?php echo esc_url($players_image['url']); ?>" alt="<?php echo esc_attr($players_image['alt']); ?>">
    </div>
    <div class="main__container">
        <div class="main__text_block">
            <div class="main__rating"> <span><?php the_field('ex_rating_b2'); ?></span></div>
            <div class="main__heading"> 
                <h1><?php the_field('ex_heading_b2'); ?></h1>
            </div>
            <div class="main__subheading">
                <p><?php the_field('ex_subheading_b2'); ?></p>
            </div>
            <a href="<?php echo esc_url(casino_b2_get_global_button_url()); ?>" class="main-btn"> <span><?php pll_e('Get Bonus'); ?></span></a>
        </div>
    </div>
</section>

<section class="content">
    <div class="content__container">
        <div class="sidebar show-item active">
            <div class="sidebar__heading"><span><?php pll_e('In this review'); ?></span><img src="<?php echo get_template_directory_uri(); ?>/assets/public/img/icons/wide-arrow-bottom-yellow.svg" alt=""></div>
            <div class="sidebar__items show-text active">
                <?php
                $id_counter = 1;
                if( have_rows('ex_content_b2') ):
                    while( have_rows('ex_content_b2') ): the_row();
                        if (get_row_layout() == 'text_image_block') {
                            $heading = get_sub_field('heading');
                            if ($heading) {
                                echo '<a class="sidebar__item" href="#a' . $id_counter . '"><span>' . esc_html($heading) . '</span></a>';
                                $id_counter++;
                            }
                        } elseif ( get_row_layout() == 'faq_block' ) {
                            $heading = get_sub_field('heading');
                            if ($heading) {
                                echo '<a class="sidebar__item" href="#questions"><span>' . esc_html($heading) . '</span></a>';
                            }
                        }
                    endwhile;
                    reset_rows();
                endif;
                ?>
            </div>
        </div>
        <div class="content__items">
            <?php
            if (have_rows('ex_content_b2')):
                $id_counter = 1;
                while (have_rows('ex_content_b2')) : the_row();
                    if (get_row_layout() == 'intro_block') :
                        $content = get_sub_field('content');
                        ?>
                        <div class="content__item">
                            <div class="text-part">
                                <?php echo $content; ?>
                            </div>
                        </div>
                        <?php
                    elseif (get_row_layout() == 'text_image_block') :
                        $heading = get_sub_field('heading');
                        $image = get_sub_field('image');
                        $content = get_sub_field('content');
                        $show_button = get_sub_field('show_button');
                        ?>
                        <div class="content__item">
                            <div class="text-part">
                                <?php if ($heading) : ?>
                                    <h2 id="a<?php echo $id_counter++; ?>"><?php echo esc_html($heading); ?></h2>
                                <?php endif; ?>
                                <?php if ($image && !empty($image['url'])) : ?>
                                    <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr($image['alt']); ?>">
                                <?php endif; ?>
                                <?php echo $content; ?>
                                <?php if ($show_button) : ?>
                                    <a href="<?php echo esc_url(casino_b2_get_global_button_url()); ?>" class="main-btn"><span><?php pll_e('Get Bonus'); ?></span></a>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php
                    elseif (get_row_layout() == 'faq_block') :
                        ?>
                        <div class="content__item" id="questions">
                            <div class="questions">
                                <div class="questions__heading"><h2><?php the_sub_field('heading'); ?></h2></div>
                                <div class="questions__items">
                                    <?php while(have_rows('items')) : the_row(); ?>
                                    <div class="questions__item show-item">
                                        <div class="questions__item_heading">
                                            <span><?php the_sub_field('question'); ?></span>
                                            <img src="<?php echo get_template_directory_uri(); ?>/assets/public/img/icons/arrow-bottom.svg" alt="">
                                        </div>
                                        <div class="questions__item_text show-text">
                                            <?php the_sub_field('answer'); ?>
                                        </div>
                                    </div>
                                    <?php endwhile; ?>
                                </div>
                            </div>
                        </div>
                        <?php
                    endif;
                endwhile;
            endif;
            ?>
        </div>
    </div>
    <a class="content__arr_top" href="#backTop"><img src="<?php echo get_template_directory_uri(); ?>/assets/public/img/content/top-btn.png" alt=""></a>
</section>

<?php get_footer(); ?>
