<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, user-scalable=no, viewport-fit=contain">
    <?php wp_head(); ?>

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&amp;family=Ultra&amp;display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/public/css/style.min.css">
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/custom.css">
    <meta name="google-site-verification" content="WhzhqLT_uP351gClIIB6EtAw8LFk9rHZivloCFiBFf4" />
</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<div class="body-wrap" id="backTop">
    <header class="header">
        <div class="container">
            <div class="header__menu">
                <ul>
                    <?php 
                    $header_menu = casino_b2_get_header_menu();
                    if ($header_menu) : 
                        foreach ($header_menu as $item) : ?>
                            <li>
                                <a href="<?php echo esc_url($item['url']); ?>"> 
                                    <span><?php echo esc_html($item['title']); ?></span>
                                    <?php if (!empty($item['submenu'])) : ?>
                                        <?php $arrow_attr = get_static_image_attr(); ?>
                                        <img class="arrow" src="<?php echo get_template_directory_uri(); ?>/assets/public/img/icons/arrow-bottom-header.svg" alt="<?php echo esc_attr($arrow_attr['alt']); ?>" title="<?php echo esc_attr($arrow_attr['title']); ?>">
                                    <?php endif; ?>
                                </a>
                                <?php if (!empty($item['submenu'])) : ?>
                                    <ul>
                                        <?php foreach ($item['submenu'] as $sub_item) : ?>
                                            <li><a href="<?php echo esc_url($sub_item['url']); ?>"><?php echo esc_html($sub_item['title']); ?></a></li>
                                        <?php endforeach; ?>
                                    </ul>
                                <?php endif; ?>
                            </li>
                        <?php endforeach; 
                    endif; ?>
                </ul>
            </div>
            <?php $logo = casino_b2_get_header_logo(); ?>
            <a class="header__logo" href="<?php echo home_url('/'); ?>"><img src="<?php echo esc_url($logo['url']); ?>" alt="<?php echo esc_attr($logo['alt']); ?>"></a>
            <div class="header__rightside">
                <div class="header__btn_block">
                    <a href="<?php echo esc_url(casino_b2_get_global_button_url()); ?>" class="button button--green"><span><?php pll_e('Log In'); ?></span></a>
                    <a href="<?php echo esc_url(casino_b2_get_global_button_url()); ?>" class="button button--yellow"><span><?php pll_e('Register'); ?></span></a>
                </div>
                <div class="header__lang_block">
                    <?php 
                    if (function_exists('pll_the_languages')) {
                        $languages = pll_the_languages(array('raw' => 1));
                        $current_lang_slug = pll_current_language();
                        
                        $lang_flags = [
                            'en' => 'eng',
                            'de' => 'de',
                            'it' => 'it',
                            'pt' => 'pt',
                            'pl' => 'pl',
                        ];

                        if (!empty($languages)) :
                            $current_lang_flag_code = isset($lang_flags[$current_lang_slug]) ? $lang_flags[$current_lang_slug] : 'eng';
                    ?>
                        <?php $lang_flag_attr = get_static_image_attr('', '', 'flag', $current_lang_slug); ?>
                        <div class="header__lang_item header__lang_item--active data-toggle">
                            <img src="<?php echo get_template_directory_uri(); ?>/assets/public/img/icons/flags/<?php echo $current_lang_flag_code; ?>.svg" alt="<?php echo esc_attr($lang_flag_attr['alt']); ?>" title="<?php echo esc_attr($lang_flag_attr['title']); ?>">
                        </div>
                        <div class="header__lang_hidden data-toggle-item">
                            <?php foreach ($languages as $lang) : 
                                if ($lang['slug'] != $current_lang_slug) :
                                    $flag_code = isset($lang_flags[$lang['slug']]) ? $lang_flags[$lang['slug']] : 'eng';
                                    $other_flag_attr = get_static_image_attr('', '', 'flag', $lang['slug']);
                                ?>
                                    <a class="header__lang_item" href="<?php echo esc_url($lang['url']); ?>"><img src="<?php echo get_template_directory_uri(); ?>/assets/public/img/icons/flags/<?php echo $flag_code; ?>.svg" alt="<?php echo esc_attr($other_flag_attr['alt']); ?>" title="<?php echo esc_attr($other_flag_attr['title']); ?>"></a>
                                <?php endif;
                            endforeach; ?>
                        </div>
                    <?php 
                        endif;
                    } 
                    ?>
                </div>
                <div class="header__mob_menu">
                    <div id="burger" onclick="enable()"><span> </span><span class="ultinate"></span><span> </span></div>
                    <nav class="nav" id="nav">
                        <a class="nav__mob_logo" href="<?php echo home_url('/'); ?>"><img src="<?php echo esc_url($logo['url']); ?>" alt="<?php echo esc_attr($logo['alt']); ?>"></a>
                        <div class="nav__menu">
                            <ul>
                                <?php 
                                // Use the same menu items as the header
                                $header_menu = casino_b2_get_header_menu();
                                if ($header_menu) : 
                                    foreach ($header_menu as $item) : ?>
                                        <li<?php echo !empty($item['submenu']) ? ' class="show-item show-item-has-submenu"' : ''; ?>>
                                            <?php if (!empty($item['submenu'])) : ?>
                                                <a href="<?php echo esc_url($item['url']); ?>">
                                                    <?php echo esc_html($item['title']); ?>
                                                </a>
                                                <ul class="show-text">
                                                    <?php foreach ($item['submenu'] as $sub_item) : ?>
                                                        <li><a href="<?php echo esc_url($sub_item['url']); ?>">
                                                            <span><?php echo esc_html($sub_item['title']); ?></span>
                                                        </a></li>
                                                    <?php endforeach; ?>
                                                </ul>
                                            <?php else : ?>
                                                <a href="<?php echo esc_url($item['url']); ?>">
                                                    <span><?php echo esc_html($item['title']); ?></span>
                                                </a>
                                            <?php endif; ?>
                                        </li>
                                    <?php endforeach; 
                                endif; ?>
                            </ul>
                        </div>
                        <div class="nav__btns">
                            <a href="<?php echo esc_url(casino_b2_get_global_button_url()); ?>" class="button button--green"><span><?php pll_e('Log In'); ?></span></a>
                            <a href="<?php echo esc_url(casino_b2_get_global_button_url()); ?>" class="button button--yellow"><span><?php pll_e('Register'); ?></span></a>
                        </div>
                    </nav>
                </div>
            </div>
        </div>
    </header>
