Element.prototype.closest || (Element.prototype.closest = function(t) { for (var e = this; e;) { if (e.matches(t)) return e;e = e.parentElement } return null });

Element.prototype.matches || (Element.prototype.matches = Element.prototype.matchesSelector || Element.prototype.webkitMatchesSelector || Element.prototype.mozMatchesSelector || Element.prototype.msMatchesSelector);

Object.assign || Object.defineProperty(Object, "assign", { enumerable: !1, configurable: !0, writable: !0, value: function(e) { "use strict"; if (null == e) throw new TypeError("Cannot convert first argument to object"); for (var t = Object(e), n = 1; n < arguments.length; n++) { var o = arguments[n]; if (null != o) for (var a = Object.keys(Object(o)), c = 0, b = a.length; c < b; c++) { var i = a[c], l = Object.getOwnPropertyDescriptor(o, i); void 0 !== l && l.enumerable && (t[i] = o[i]) } } return t } });

window.NodeList && !NodeList.prototype.forEach && (NodeList.prototype.forEach = Array.prototype.forEach);

function $$(e, o, t) { "function" != typeof o ? o = o || document : (t = o, o = document); var c = o.querySelectorAll(e); return c = Array.prototype.slice.call(o.querySelectorAll(e)), "function" == typeof t && c.forEach(function(e, o, c) { t(e, o, c) }), c }

function addCss(r, s) { var a = function(r) { Object.assign(r.style, s) }; if (Array.isArray(r))
        for (var n = r.length - 1; n >= 0; n--) a(r[n]);
    else a(r) }

function getElementIndex(e) { for (var n = 0; e = e.previousElementSibling;) n++; return n }

function h_el(r) { return !!(Array.isArray(r) && r.length > 0) }

function debugging() { [].forEach.call($$("*"), function(n) { n.style.outline = "1px solid #" + (~~(Math.random() * (1 << 24))).toString(16) }) }

function addEv(obj, evt, func) {
    if (obj) {
        if ('addEventListener' in window) obj.addEventListener(evt, func, false);
        else if ('attachEvent' in window) obj.attachEvent('on' + evt, func);

    }
}

document.addEventListener('click', e => {
    const link = e.target.closest('a[href^="#"]');
    if (link) {
        e.preventDefault();
        const target = document.querySelector(link.getAttribute('href'));
        if (target) target.scrollIntoView({ behavior: 'smooth' });
    }
});


//VIS ON SCROLL
let showels = document.querySelectorAll(".vis_on_scroll");
let windowHeight = window.innerHeight;
let docElement = document.documentElement;
function isVisible(el) {
    let scrollY = window.scrollY || docElement.scrollTop;
    let viewportTop = scrollY + windowHeight - windowHeight / 6;
    return viewportTop > el.getBoundingClientRect().top + scrollY;
}
function showOnScroll() {
    showels.forEach((el) => {
        if (isVisible(el)) {
            el.classList.add("visible");
        }
    });
}
window.addEventListener('scroll', () => {
    requestAnimationFrame(showOnScroll);
});
showOnScroll();




// Mob menu
const enable = (e) => {
  document.getElementById('burger').classList.toggle('open');
  document.getElementById('nav').classList.toggle('nav-open');
  document.getElementsByTagName('body')[0].classList.toggle('locked');
  let menuItems = document.querySelectorAll('.nav__menu a');
  menuItems.forEach(el =>{
    el.addEventListener("click", ()=>{
      document.getElementById('burger').classList.remove('open');
      document.getElementById('nav').classList.remove('nav-open');
      document.getElementsByTagName('body')[0].classList.remove('locked');
    })
  });
}



const gamesSlider = document.querySelector(".games__slider");
if (gamesSlider) {
  const games = new Swiper("#gamesSlider", {
    slidesPerView: 'auto',
    spaceBetween: 16,
    loop: true,
    speed: 600,
    allowTouchMove: true,
    initialSlide: 0,
    centerSlides: true,
    breakpoints: {
      1025: {
        allowTouchMove: false,
        slidesPerView: 'auto',
      },
    },
    navigation: {
        nextEl: ".arrow-next",
        prevEl: ".arrow-prev",
    },
  });
}

$$('.show-item', el => {
    el.addEventListener('click', function(){
        let currAccItem = el;
        let currAccBody = currAccItem.querySelector('.show-text');
        
        if (!currAccBody) {
            return;
        }

        function addClassActive(h) {
            currAccBody.style.height = `${h}px`;
        }

        if (!currAccItem.classList.contains('active')) {
            $$('.show-item.active', otherItem => {
                if (otherItem !== currAccItem) {
                    let otherBody = otherItem.querySelector('.show-text');
                    if (otherBody) {
                        otherBody.style.height = '0px';
                        otherItem.classList.remove('active');
                    }
                }
            });

            let cacheHeight = currAccBody.offsetHeight;
            currAccBody.style.height = 'auto';
            let currHeight = currAccBody.offsetHeight;
            currAccBody.style.height = cacheHeight + 'px';
            setTimeout(addClassActive, 20, currHeight);
        } else {
            setTimeout(addClassActive, 20, 0);
        }
        
        currAccItem.classList.toggle('active'); 
    });
});



    
function initSidebar() {
    function isMobile() {
        return window.innerWidth <= 1024 && window.matchMedia("(orientation: portrait)").matches;
    }

    document.querySelectorAll('.show-item-2').forEach(header => {
        header.classList.remove('active');
    });
    document.querySelectorAll('.show-text-2').forEach(body => {
        const items = body.querySelectorAll('.show-act-time');
        items.forEach(item => item.classList.remove('anim'));
        body.style.height = '0px';
    });

    const headers = document.querySelectorAll('.show-item-2');
    
    headers.forEach(header => {
        const body = header.nextElementSibling;
        
        if (!body || !body.classList.contains('show-text-2')) {
            return;
        }

        if (!isMobile()) {
            header.classList.add('active');
            body.style.height = 'auto';
            const items = body.querySelectorAll('.show-act-time');
            items.forEach(item => item.classList.add('anim'));
        }

        header.removeEventListener('click', header._clickHandler);
        
        header._clickHandler = function() {
            const items = body.querySelectorAll('.show-act-time');
            
            if (header.classList.contains('active')) {
                header.classList.remove('active');
                items.forEach(item => item.classList.remove('anim'));
                setTimeout(() => {
                    body.style.height = '0px';
                }, 200);
            } else {
                document.querySelectorAll('.show-item-2.active').forEach(otherHeader => {
                    if (otherHeader !== header) {
                        otherHeader.classList.remove('active');
                        const otherBody = otherHeader.nextElementSibling;
                        if (otherBody && otherBody.classList.contains('show-text-2')) {
                            const otherItems = otherBody.querySelectorAll('.show-act-time');
                            otherItems.forEach(item => item.classList.remove('anim'));
                            otherBody.style.height = '0px';
                        }
                    }
                });

                header.classList.add('active');
                body.style.height = 'auto';
                const fullHeight = body.offsetHeight;
                body.style.height = '0px';
                
                setTimeout(() => {
                    body.style.height = fullHeight + 'px';
                }, 10);

                setTimeout(() => {
                    items.forEach((item, index) => {
                        setTimeout(() => {
                            item.classList.add('anim');
                        }, index * 50);
                    });
                }, 100);
            }
        };
        
        header.addEventListener('click', header._clickHandler);
    });
}

initSidebar();

let resizeTimer;
window.addEventListener('resize', function() {
    clearTimeout(resizeTimer);
    resizeTimer = setTimeout(initSidebar, 100);
});

window.addEventListener('orientationchange', function() {
    setTimeout(initSidebar, 300);
});




function initToggleAnimation() {
    const triggers = document.querySelectorAll('.data-toggle');
    
    triggers.forEach(trigger => {
        let isActive = false;
        
        trigger.addEventListener('click', function(e) {
            e.preventDefault();
            
            // Ищем все .data-toggle-item внутри ближайшего общего родителя
            const container = trigger.parentElement;
            const items = container ? container.querySelectorAll('.data-toggle-item') 
                                   : document.querySelectorAll('.data-toggle-item');
            
            if (items.length === 0) return;
            
            isActive = !isActive;
            trigger.classList.toggle('active', isActive);
            
            items.forEach((item, index) => {
                setTimeout(() => {
                    item.classList.toggle('active', isActive);
                }, index * 100);
            });
        });
    });
} initToggleAnimation();


