<?php
/*
Template Name: Example Page Template
*/

// Функция для добавления ID к тегам H2 в контенте
function add_ids_to_h2($content) {
    // Заменяем все H2 теги на теги с ID атрибутами в формате a1, a2, a3
    $content = preg_replace_callback('/<h2(?:\s+[^>]*)?>(.*?)<\/h2>/i', function($matches) {
        static $count = 0;
        $count++;
        return '<h2 id="a' . $count . '">' . $matches[1] . '</h2>';
    }, $content);
    
    return $content;
}

// Функция для извлечения H2 тегов и их текста
function extract_h2_tags($content) {
    $h2_tags = [];
    
    preg_match_all('/<h2\s+id="a(\d+)">(.*?)<\/h2>/i', $content, $matches, PREG_SET_ORDER);
    
    foreach($matches as $match) {
        $id = 'a' . $match[1]; // Используем ID из тега в формате a1, a2, a3
        $text = strip_tags($match[2]);
        $h2_tags[] = ['id' => $id, 'text' => $text];
    }
    
    return $h2_tags;
}

// Получение значений полей ACF для главного баннера
$ex_rating = get_field('ex_rating') ?: 'Overall Rating: 95 / 100';
$ex_heading = get_field('ex_heading') ?: 'Online Casino Website';
$ex_subheading = get_field('ex_subheading') ?: 'The first thing that catches players\'s attention is the incredible simplicity of this casino.';
$ex_button = get_field('ex_button');
$ex_image_data = get_field('ex_image');
$ex_image_url = !empty($ex_image_data['url']) ? $ex_image_data['url'] : get_template_directory_uri() . '/assets/public/img/main-banner/image-1.png';
$ex_image_alt = !empty($ex_image_data['alt']) ? $ex_image_data['alt'] : $ex_heading;
$link_url = casino_get_global_button_url();

// Получение значений для вводного текста
$ex_intro_content = get_field('ex_intro_content');

// Получение значений для lorem блоков
$ex_lorem_blocks = get_field('ex_lorem_blocks');

// Получение значений для секции FAQ
$ex_faq_heading = get_field('ex_faq_heading') ?: 'Frequently Asked Questions';
$ex_faq_items = get_field('ex_faq_items');

// Глобальная URL для кнопок
$global_button_url = casino_get_global_button_url();

// Сбрасываем счетчик H2 тегов для каждой страницы
global $h2_counter;
$h2_counter = 0;

// Обработка вводного контента
if ($ex_intro_content) {
    $ex_intro_content = add_ids_to_h2($ex_intro_content);
}

// Создаем массив для Table of Content
$toc_items = [];

// Добавляем заголовки из блоков lorem
if (is_array($ex_lorem_blocks) && !empty($ex_lorem_blocks)) {
    // Счетчик для нумерации H2 тегов в сквозном порядке
    static $h2_index = 0;
    
    foreach ($ex_lorem_blocks as $block) {
        $h2_index++;
        $block_id = 'a' . $h2_index; // Используем формат a1, a2, a3
        $title = isset($block['title']) ? $block['title'] : 'Lorem ipsum dolor sit amet';
        
        // Добавляем заголовок блока в TOC
        $toc_items[] = ['id' => $block_id, 'text' => $title];
        
        // Если есть контент, проверяем на наличие H2 внутри
        if (isset($block['content']) && !empty($block['content'])) {
            $content = add_ids_to_h2($block['content']);
            $h2_tags = extract_h2_tags($content);
            if (!empty($h2_tags)) {
                $toc_items = array_merge($toc_items, $h2_tags);
            }
            // Сохраняем обработанный контент
            $ex_lorem_blocks[key($ex_lorem_blocks)]['content'] = $content;
        }
        
        next($ex_lorem_blocks); // Переходим к следующему элементу
    }
}

// Добавляем заголовок FAQ
if ($ex_faq_heading) {
    $toc_items[] = ['id' => 'questions', 'text' => $ex_faq_heading];
}

get_header();
?>

<section class="main-banner">
    <div class="container">
        <div class="main-banner__main">
        <div class="main-banner__text_block">
            <div class="main-banner__rate"><span><?php echo esc_html($ex_rating); ?></span></div>
            <div class="main-banner__heading"> 
            <h1><?php echo esc_html($ex_heading); ?></h1>
            </div>
            <div class="main-banner__subheading">
            <p><?php echo esc_html($ex_subheading); ?></p>
            </div>
            <div class="main-banner__button">
                <a class="button button--mainbaner" href="<?php echo esc_url($link_url); ?>" target="_self">
                    <span><?php pll_e('get_a_bonus'); ?></span>
                </a>
            </div>
        </div>
        <div class="main-banner__image">
            <img src="<?php echo esc_url($ex_image_url); ?>" alt="<?php echo esc_attr($ex_image_alt); ?>">
        </div>
    </div>
    </section>
    <section class="page-content">
    <div class="container"> 
        <div class="page-content__main">
        <div class="page-content__info">
            <!-- Вводный текст -->
            <div class="page-content__info_item">
                <?php if($ex_intro_content): ?>
                    <?php echo $ex_intro_content; ?>
                <?php endif; ?>
            </div>
            
            <!-- Lorem блоки -->
            <?php if(is_array($ex_lorem_blocks) && !empty($ex_lorem_blocks)):
                $lorem_block_count = 0;
                foreach($ex_lorem_blocks as $block):
                    $lorem_block_count++;
                    $block_id = 'a' . $lorem_block_count;
                    $title = isset($block['title']) ? $block['title'] : '';
                    $image_data = isset($block['image']) ? $block['image'] : null;
                    $image_url = !empty($image_data['url']) ? $image_data['url'] : '';
                    $image_alt = !empty($image_data['alt']) ? $image_data['alt'] : $title;
                    $content = isset($block['content']) ? $block['content'] : '';
                    $show_button = isset($block['show_button']) ? $block['show_button'] : false;
            ?>
                <div class="page-content__info_item" id="<?php echo esc_attr($block_id); ?>">
                    <?php if($title): ?>
                        <h2><?php echo esc_html($title); ?></h2>
                    <?php endif; ?>
                    
                    <?php if($image_url): ?>
                        <img class="simple" src="<?php echo esc_url($image_url); ?>" alt="<?php echo esc_attr($image_alt); ?>">
                    <?php endif; ?>
                    
                    <?php if($content): ?>
                        <?php echo $content; ?>
                    <?php endif; ?>
                    
                    <?php if($show_button): ?>
                        <a class="button button--mainbaner" href="<?php echo esc_url($link_url); ?>" target="_self">
                            <span><?php pll_e('get_a_bonus'); ?></span>
                        </a>
                    <?php endif; ?>
                </div>
            <?php endforeach; endif; ?>
            <div class="page-content__info_item" id="questions">
                <h2><?php echo esc_html($ex_faq_heading); ?></h2>
                <div class="questions">
                    <?php if(is_array($ex_faq_items) && !empty($ex_faq_items)): ?>
                        <?php $faq_count = 1; ?>
                        <?php foreach($ex_faq_items as $faq): ?>
                            <div class="questions__item show-item"> 
                                <div class="questions__heading"><span><?php echo esc_html($faq_count) . '. ' . esc_html($faq['question'] ?? ''); ?></span></div>
                                <div class="questions__text show-text">
                                    <?php echo $faq['answer'] ?? ''; // WYSIWYG поле, выводим как есть ?>
                                </div>
                                <div class="questions__arrow"> <img src="<?php echo get_template_directory_uri(); ?>/assets/public/img/icons/arrow-down-grey.svg" alt=""></div>
                            </div>
                            <?php $faq_count++; ?>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
                <a class="page-content__up_button" href="#backTop">
                    <img src="<?php echo get_template_directory_uri(); ?>/assets/public/img/icons/arrow-up.svg" alt="">
                </a>
            </div>
        </div>
        <div class="sidebar"> 
            <div class="sidebar__heading show-item-2 active">
                <h4><?php pll_e('table_of_contents'); ?></h4>
                <img src="<?php echo get_template_directory_uri(); ?>/assets/public/img/icons/arrow-down-white.svg" alt="">
            </div>
            <div class="sidebar__items show-text-2 active">
                <?php if(is_array($toc_items) && !empty($toc_items)): ?>
                    <?php foreach($toc_items as $item): ?>
                        <a class="sidebar__item show-act-time" href="#<?php echo esc_attr($item['id']); ?>"><span><?php echo esc_html($item['text']); ?></span></a>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
        </div>
    </div>
    </section>

<?php
get_footer();
